/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.client.gui;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.api.IWolfArmorCapability;
import com.attributestudios.wolfarmor.api.util.Capabilities;
import com.attributestudios.wolfarmor.api.util.Resources;
import com.attributestudios.wolfarmor.common.inventory.ContainerWolfInventory;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiWolfInventory
extends GuiContainer {
    private IInventory wolfInventory;
    private IInventory playerInventory;
    private EntityWolf theWolf;
    private float screenPositionX;
    private float screenPositionY;
    private final IWolfArmorCapability wolfArmor;

    public GuiWolfInventory(@Nonnull IInventory playerInventory, @Nonnull IInventory wolfInventory, @Nonnull EntityWolf theWolf, @Nonnull EntityPlayer player) {
        super((Container)new ContainerWolfInventory(playerInventory, wolfInventory, theWolf, player));
        this.wolfArmor = (IWolfArmorCapability)theWolf.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
        this.wolfInventory = wolfInventory;
        this.playerInventory = playerInventory;
        this.theWolf = theWolf;
        this.field_146291_p = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String wolfName = this.theWolf.func_145818_k_() ? this.theWolf.func_95999_t() : I18n.func_135052_a((String)"entity.Wolf.name", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(this.wolfInventory.func_145818_k_() ? this.wolfInventory.func_70005_c_() : I18n.func_135052_a((String)this.wolfInventory.func_70005_c_(), (Object[])new Object[]{wolfName}), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_70005_c_() : I18n.func_135052_a((String)this.playerInventory.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
        this.drawWolfHealthAndArmor();
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.screenPositionX = mouseX;
        this.screenPositionY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Resources.TEXTURE_GUI_WOLF_INVENTORY);
        int positionX = (this.field_146294_l - this.field_146999_f) / 2;
        int positionY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(positionX, positionY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.wolfArmor.getHasArmor()) {
            this.func_73729_b(positionX + 7, positionY + 17, this.field_146999_f, 36, 18, 18);
        }
        if (this.wolfArmor.getHasChest()) {
            this.func_73729_b(positionX + 97, positionY + 17, this.field_146999_f, 0, 54, 36);
        }
        GuiInventory.func_147046_a((int)(positionX + 51), (int)(positionY + 60), (int)30, (float)((float)(positionX + 51) - this.screenPositionX), (float)((float)(positionY - 50) - this.screenPositionY), (EntityLivingBase)this.theWolf);
        GlStateManager.func_179121_F();
    }

    private void drawWolfHealthAndArmor() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        if (WolfArmorMod.getConfiguration().getIsWolfHealthDisplayEnabled()) {
            int health = (int)Math.ceil(this.theWolf.func_110143_aJ());
            float maxHealth = this.theWolf.func_110138_aP();
            int rowOffset = (int)Math.min((maxHealth + 0.5f) / 2.0f, 30.0f);
            int yPosition = 56;
            if (!WolfArmorMod.getConfiguration().getIsWolfArmorDisplayEnabled() || !this.wolfArmor.getHasArmor()) {
                yPosition += 5;
            }
            int columnOffset = 0;
            while (rowOffset > 0) {
                int rowIterate = Math.min(rowOffset, 10);
                rowOffset -= rowIterate;
                for (int row = rowIterate - 1; row >= 0; --row) {
                    int xPosition = this.field_146999_f / 2 + row * 8 - 4;
                    this.func_73729_b(xPosition, yPosition, 16, 0, 9, 9);
                    if (row * 2 + 1 + columnOffset < health) {
                        this.func_73729_b(xPosition, yPosition, 52, 0, 9, 9);
                    }
                    if (row * 2 + 1 + columnOffset != health) continue;
                    this.func_73729_b(xPosition, yPosition, 61, 0, 9, 9);
                }
                columnOffset += 20;
            }
        }
        if (WolfArmorMod.getConfiguration().getIsWolfArmorDisplayEnabled() && this.wolfArmor.getHasArmor()) {
            int yPosition = 66;
            if (!WolfArmorMod.getConfiguration().getIsWolfHealthDisplayEnabled()) {
                yPosition -= 5;
            }
            int armor = this.theWolf.func_70658_aO();
            double maxArmor = 20.0;
            int rowOffset = (int)Math.min((maxArmor + 0.5) / 2.0, 30.0);
            int columnOffset = 0;
            while (rowOffset > 0) {
                int rowIterate = Math.min(rowOffset, 10);
                rowOffset -= rowIterate;
                for (int row = rowIterate - 1; row >= 0; --row) {
                    int xPosition = this.field_146999_f / 2 + row * 8 - 4;
                    this.func_73729_b(xPosition, yPosition, 16, 9, 9, 9);
                    if (row * 2 + 1 + columnOffset < armor) {
                        this.func_73729_b(xPosition, yPosition, 34, 9, 9, 9);
                    }
                    if (row * 2 + 1 + columnOffset != armor) continue;
                    this.func_73729_b(xPosition, yPosition, 25, 9, 9, 9);
                }
                columnOffset += 20;
            }
        }
        GlStateManager.func_179121_F();
    }
}

