/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class ReflectionCache {
    private static Map<String, Field> CACHED_REFLECTION_FIELDS = Maps.newHashMap();
    private static Map<String, Method> CACHED_REFLECTION_METHODS = Maps.newHashMap();
    private static Exception lastError;

    @Nullable
    public static Field getField(@Nonnull Class clazz, @Nonnull String fieldName, @Nonnull String fieldObfName) {
        String key = String.format("%s.%s", clazz.getName(), fieldObfName);
        Field field = null;
        if (CACHED_REFLECTION_FIELDS.containsKey(key)) {
            field = CACHED_REFLECTION_FIELDS.get(key);
        }
        if (field == null) {
            try {
                field = ReflectionHelper.findField((Class)clazz, (String[])new String[]{fieldName, fieldObfName});
                CACHED_REFLECTION_FIELDS.put(key, field);
            }
            catch (Exception ex) {
                WolfArmorMod.getLogger().error(ex);
                ReflectionCache.setLastError(ex);
            }
        }
        return field;
    }

    @Nullable
    public static <E> Method getMethod(@Nonnull Class<? super E> clazz, @Nonnull String methodName, @Nullable String methodObfName, Class<?> ... params) {
        Method method = null;
        StringBuilder keyParams = new StringBuilder("(");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    keyParams.append(", ");
                }
                keyParams.append(params[i].getName());
            }
        }
        keyParams.append(")");
        String key = clazz.getName() + "." + methodObfName + keyParams;
        if (CACHED_REFLECTION_METHODS.containsKey(key)) {
            method = CACHED_REFLECTION_METHODS.get(key);
        }
        if (method == null) {
            try {
                method = ReflectionHelper.findMethod(clazz, (String)methodName, (String)methodObfName, (Class[])params);
                CACHED_REFLECTION_METHODS.put(key, method);
            }
            catch (Exception ex) {
                WolfArmorMod.getLogger().error(ex);
                ReflectionCache.setLastError(ex);
            }
        }
        return method;
    }

    @Nullable
    public static Exception getLastError() {
        return lastError;
    }

    private static void setLastError(@Nullable Exception lastError) {
        ReflectionCache.lastError = lastError;
    }
}

