/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.capabilities;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.advancements.WolfArmorTrigger;
import com.attributestudios.wolfarmor.api.IWolfArmorCapability;
import com.attributestudios.wolfarmor.api.util.Capabilities;
import com.attributestudios.wolfarmor.api.util.Criteria;
import com.attributestudios.wolfarmor.api.util.Resources;
import com.attributestudios.wolfarmor.common.network.PacketHandler;
import com.attributestudios.wolfarmor.common.network.packets.WolfArmorCapabilityDataMessage;
import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class CapabilityWolfArmor
implements IWolfArmorCapability,
ICapabilitySerializable<NBTTagCompound>,
IInventoryChangedListener {
    private static final Storage STORAGE = new Storage();
    private static final int MAX_SIZE_INVENTORY = 7;
    private static final int INVENTORY_SLOT_ARMOR = 0;
    public static final int INVENTORY_SLOT_CHEST_START = 1;
    public static final int INVENTORY_SLOT_CHEST_LENGTH = 6;
    private final EntityWolf wolf;
    private ContainerHorseChest inventory;
    private ItemStack wolfArmorItem = ItemStack.field_190927_a;
    private boolean hasChest;

    public static void register() {
        CapabilityManager.INSTANCE.register(IWolfArmorCapability.class, (Capability.IStorage)STORAGE, () -> {
            try {
                return (IWolfArmorCapability)CapabilityWolfArmor.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static boolean isValidWolfArmor(@Nonnull ItemStack armorItemStack) {
        return armorItemStack.func_190926_b() || CapabilityWolfArmor.isValidWolfArmor(armorItemStack.func_77973_b());
    }

    public static boolean isValidWolfArmor(@Nullable Item armorItem) {
        return armorItem instanceof ItemWolfArmor;
    }

    private CapabilityWolfArmor(@Nonnull EntityWolf wolf) {
        this.wolf = wolf;
        this.inventoryInit();
    }

    private void inventoryInit() {
        ContainerHorseChest inventoryExisting = this.inventory;
        this.inventory = new ContainerHorseChest("inventory.wolfarmor.wolf", this.getMaxSizeInventory());
        String customWolfName = this.wolf.func_95999_t();
        if (!customWolfName.isEmpty()) {
            this.inventory.func_110133_a(customWolfName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int slotCount = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < slotCount; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    private void playEquipSound(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SoundEvent sound = null;
        if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150486_ae) {
            sound = SoundEvents.field_187665_Y;
        }
        if (sound != null) {
            this.wolf.func_184185_a(sound, 1.0f, (this.wolf.func_70681_au().nextFloat() - this.wolf.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void openWolfInventory(@Nonnull EntityPlayer player) {
        if (!this.wolf.func_130014_f_().field_72995_K) {
            this.wolf.func_70907_r().func_75270_a(true);
            player.openGui((Object)WolfArmorMod.getInstance(), this.wolf.func_145782_y(), this.wolf.func_130014_f_(), MathHelper.func_76128_c((double)this.wolf.field_70165_t), MathHelper.func_76128_c((double)this.wolf.field_70163_u), MathHelper.func_76128_c((double)this.wolf.field_70161_v));
        }
    }

    public void func_76316_a(@Nonnull IInventory inventory) {
        if (!this.wolf.func_130014_f_().field_72995_K) {
            ItemStack armorItemStack = inventory.func_70301_a(0);
            this.setArmorItemStack(armorItemStack);
            this.applyArmorModifiers(this.wolf.func_110148_a(SharedMonsterAttributes.field_188791_g), armorItemStack);
            this.applyArmorModifiers(this.wolf.func_110148_a(SharedMonsterAttributes.field_189429_h), armorItemStack);
        }
    }

    private void applyArmorModifiers(@Nullable IAttributeInstance instance, @Nonnull ItemStack stack) {
        if (instance == null) {
            return;
        }
        instance.func_188479_b(ItemWolfArmor.ARMOR_UUID);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemWolfArmor)) {
            return;
        }
        ItemWolfArmor armorItem = (ItemWolfArmor)stack.func_77973_b();
        Multimap<String, AttributeModifier> map = armorItem.getAttributeModifiers(EntityEquipmentSlot.CHEST, stack);
        if (map.containsKey((Object)instance.func_111123_a().func_111108_a())) {
            map.get((Object)instance.func_111123_a().func_111108_a()).forEach(arg_0 -> ((IAttributeInstance)instance).func_111121_a(arg_0));
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        Boolean hasChest = this.getHasChest();
        tags.func_74757_a("hasChest", hasChest.booleanValue());
        if (hasChest.booleanValue()) {
            NBTTagList inventoryItems = new NBTTagList();
            InventoryBasic inventory = this.getInventory();
            for (byte slotIndex = 0; slotIndex < inventory.func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = inventory.func_70301_a((int)slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound stackInSlotTags = new NBTTagCompound();
                stackInSlotTags.func_74774_a("slot", slotIndex);
                stackInSlot.func_77955_b(stackInSlotTags);
                inventoryItems.func_74742_a((NBTBase)stackInSlotTags);
            }
            tags.func_74782_a("inventory", (NBTBase)inventoryItems);
        }
        if (this.getHasArmor()) {
            ItemStack armorItemStack = this.getArmorItemStack();
            if (!armorItemStack.func_190926_b()) {
                NBTTagCompound armorItemTag = armorItemStack.func_77955_b(new NBTTagCompound());
                tags.func_74782_a("armorItem", (NBTBase)armorItemTag);
            } else {
                tags.func_82580_o("armorItem");
            }
        }
        return tags;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound tags) {
        NBTTagCompound armorTags;
        boolean hasChest = tags.func_74767_n("hasChest");
        this.setHasChest(hasChest);
        if (hasChest) {
            this.inventoryInit();
            NBTTagList inventoryTagList = tags.func_150295_c("inventory", 10);
            for (int index = 0; index < inventoryTagList.func_74745_c(); ++index) {
                NBTTagCompound compoundTagAt = inventoryTagList.func_150305_b(index);
                byte slotIndex = compoundTagAt.func_74771_c("slot");
                if (slotIndex >= 0 && slotIndex < this.inventory.func_70302_i_()) {
                    this.inventory.func_70299_a((int)slotIndex, new ItemStack(compoundTagAt));
                    continue;
                }
                WolfArmorMod.getLogger().log(Level.WARN, String.format("[NBT LOAD] Discarded invalid slot information at index %d", slotIndex));
            }
        }
        if (!(armorTags = tags.func_74775_l("armorItem")).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    @Override
    public boolean getHasChest() {
        return this.hasChest;
    }

    @Override
    public void setHasChest(boolean value) {
        this.hasChest = value;
    }

    @Override
    @Nonnull
    public ItemStack getArmorItemStack() {
        return this.wolfArmorItem;
    }

    @Override
    public void setArmorItemStack(@Nonnull ItemStack value) {
        if (value != this.wolfArmorItem) {
            this.wolfArmorItem = value;
            this.wolf.func_184201_a(EntityEquipmentSlot.MAINHAND, value);
            this.wolf.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            this.wolf.func_184201_a(EntityEquipmentSlot.HEAD, value);
            this.wolf.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.wolf.func_184201_a(EntityEquipmentSlot.CHEST, value);
            this.wolf.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            this.wolf.func_184201_a(EntityEquipmentSlot.LEGS, value);
            this.wolf.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            this.wolf.func_184201_a(EntityEquipmentSlot.FEET, value);
            this.wolf.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        }
    }

    @Override
    public boolean getHasArmor() {
        return !this.getArmorItemStack().func_190926_b();
    }

    @Override
    @Nonnegative
    public int getMaxSizeInventory() {
        return 7;
    }

    @Override
    @Nonnull
    public InventoryBasic getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventoryItem(int index, @Nonnull ItemStack itemStack) {
        if (index >= 0 && index < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(index, itemStack);
        } else {
            WolfArmorMod.getLogger().log(Level.ERROR, String.format("Invalid slot: %d", index));
        }
    }

    @Override
    public boolean canEquipItem(@Nonnull ItemStack armorItemStack) {
        return CapabilityWolfArmor.isValidWolfArmor(armorItemStack) && (!this.getHasArmor() || armorItemStack.func_190926_b());
    }

    @Override
    public void equipArmor(@Nonnull ItemStack armorItemStack) {
        if (this.canEquipItem(armorItemStack)) {
            this.inventory.func_70299_a(0, armorItemStack);
        }
    }

    @Override
    public boolean processInteract(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (this.wolf.func_70631_g_() || !this.wolf.func_70909_n() || !this.wolf.func_152114_e((EntityLivingBase)player)) {
            return false;
        }
        if (player.func_70093_af()) {
            this.openWolfInventory(player);
            return true;
        }
        ItemStack itemInHand = player.func_184586_b(hand);
        if (!itemInHand.func_190926_b()) {
            boolean isWolfChestEnabled = WolfArmorMod.getConfiguration().getIsWolfChestEnabled();
            if (Block.func_149634_a((Item)itemInHand.func_77973_b()) == Blocks.field_150486_ae && isWolfChestEnabled && !this.getHasChest()) {
                if (!this.wolf.func_130014_f_().field_72995_K) {
                    this.playEquipSound(itemInHand);
                    this.setHasChest(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemInHand.func_190918_g(1);
                    }
                    if (player instanceof EntityPlayerMP) {
                        ((WolfArmorTrigger)Criteria.EQUIP_WOLF_CHEST).trigger((EntityPlayerMP)player, (Entity)this.wolf);
                    }
                }
                return true;
            }
            if (CapabilityWolfArmor.isValidWolfArmor(itemInHand)) {
                this.openWolfInventory(player);
                return true;
            }
        }
        return false;
    }

    @Override
    public void dropEquipment(boolean killedByPlayer, int lootingModifier) {
        ItemStack armorItemStack;
        if (this.getHasArmor() && !(armorItemStack = this.getArmorItemStack()).func_190926_b()) {
            this.wolf.func_70099_a(armorItemStack, 0.0f);
            this.equipArmor(ItemStack.field_190927_a);
        }
        if (this.getHasChest()) {
            this.wolf.func_70099_a(new ItemStack((Block)Blocks.field_150486_ae, 1), 0.0f);
            this.dropInventoryContents();
        }
    }

    @Override
    public void dropInventoryContents() {
        for (int slotIndex = 1; slotIndex < 7; ++slotIndex) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            this.wolf.func_70099_a(stackInSlot, 0.0f);
            this.inventory.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
    }

    @Override
    public void damageArmor(float damage) {
        ItemStack stackInSlot;
        if (this.getHasArmor() && !(stackInSlot = this.inventory.func_70301_a(0)).func_190926_b()) {
            stackInSlot.func_77972_a((int)Math.ceil(damage), (EntityLivingBase)this.wolf);
            if (stackInSlot.func_190916_E() == 0) {
                ItemStack particleStack = stackInSlot.func_77946_l();
                particleStack.func_190920_e(1);
                this.equipArmor(ItemStack.field_190927_a);
                this.wolf.func_70669_a(particleStack);
            }
        }
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.CAPABILITY_WOLF_ARMOR ? this : null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.CAPABILITY_WOLF_ARMOR;
    }

    public static final class EventHandlers {
        @SubscribeEvent
        public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
            Entity entity = (Entity)event.getObject();
            if (entity instanceof EntityWolf && !(entity instanceof IWolfArmorCapability)) {
                CapabilityWolfArmor capability = new CapabilityWolfArmor((EntityWolf)entity);
                event.addCapability(Resources.CAPABILITY_WOLF_ARMOR, (ICapabilityProvider)capability);
            }
        }

        @SubscribeEvent
        public void onEntityKnockBack(LivingKnockBackEvent event) {
            if (!event.isCanceled() && event.getOriginalAttacker() instanceof EntityWolf) {
                IWolfArmorCapability capability = (IWolfArmorCapability)event.getOriginalAttacker().getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
                if (capability == null || capability.getArmorItemStack().func_190926_b()) {
                    return;
                }
                int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)capability.getArmorItemStack());
                if (lvl > 0 && (float)lvl * 0.5f > event.getStrength()) {
                    event.setStrength((float)lvl * 0.5f);
                }
            }
        }

        @SubscribeEvent
        public void onEntityAttack(LivingHurtEvent event) {
            Entity source = event.getSource().func_76346_g();
            Entity target = event.getSource().func_76346_g();
            boolean isAttackerWolf = source instanceof EntityWolf;
            boolean isDefenderWolf = target instanceof EntityWolf;
            if (isAttackerWolf) {
                this.handleWolfAttackedOther((EntityWolf)source, event);
            }
            if (isDefenderWolf) {
                this.handleWolfAttackedBy((EntityWolf)target, event);
            }
        }

        @SubscribeEvent
        public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
            if (event.getEntity() instanceof EntityWolf) {
                EntityWolf wolf = (EntityWolf)event.getEntity();
                IWolfArmorCapability iWolfArmorCapability = (IWolfArmorCapability)wolf.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
            }
        }

        private void handleWolfAttackedBy(EntityWolf wolf, LivingHurtEvent event) {
            IWolfArmorCapability wolfArmorCapability = (IWolfArmorCapability)wolf.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
            if (wolfArmorCapability == null || wolfArmorCapability.getArmorItemStack().func_190926_b()) {
                return;
            }
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)wolfArmorCapability.getArmorItemStack());
            if ("drown".equals(event.getSource().func_76355_l()) && lvl > 0) {
                event.setCanceled(true);
                return;
            }
        }

        private void handleWolfAttackedOther(EntityWolf wolf, LivingHurtEvent event) {
            IWolfArmorCapability wolfArmorCapability = (IWolfArmorCapability)wolf.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
            if (wolfArmorCapability == null || wolfArmorCapability.getArmorItemStack().func_190926_b()) {
                return;
            }
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)wolfArmorCapability.getArmorItemStack());
            if (lvl > 0 && event.getEntityLiving() != null && !event.getEntityLiving().func_70027_ad()) {
                event.getEntityLiving().func_70015_d(lvl * 4);
            }
            if ((lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180312_n, (ItemStack)wolfArmorCapability.getArmorItemStack())) > 0 && event.getEntityLiving() instanceof EntitySpider) {
                event.setAmount(event.getAmount() + (float)lvl * 2.5f);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
            EnumHand hand;
            EntityPlayer player;
            IWolfArmorCapability wolfArmorCapability;
            if (event.getTarget() instanceof EntityWolf && (wolfArmorCapability = (IWolfArmorCapability)event.getTarget().getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null)) != null && wolfArmorCapability.processInteract(player = event.getEntityPlayer(), hand = event.getHand())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onDropItems(LivingDropsEvent event) {
            IWolfArmorCapability wolfArmorCapability;
            if (event.getEntity() instanceof EntityWolf && (wolfArmorCapability = (IWolfArmorCapability)event.getEntity().getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null)) != null) {
                DamageSource source = event.getSource();
                wolfArmorCapability.dropEquipment(source != null && source.func_76346_g() instanceof EntityPlayer, event.getLootingLevel());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onDamageArmor(LivingHurtEvent event) {
            IWolfArmorCapability wolfArmorCapability;
            if (event.getEntity() instanceof EntityWolf && (wolfArmorCapability = (IWolfArmorCapability)event.getEntity().getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null)) != null) {
                wolfArmorCapability.damageArmor(event.getAmount());
            }
        }

        @SubscribeEvent
        public void onUpdate(LivingEvent.LivingUpdateEvent event) {
            IWolfArmorCapability wolfArmorCapability;
            if (event.getEntity() instanceof EntityWolf && (wolfArmorCapability = (IWolfArmorCapability)event.getEntity().getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null)) != null && !event.getEntity().func_130014_f_().field_72995_K) {
                PacketHandler.getChannel().sendToAll((IMessage)new WolfArmorCapabilityDataMessage(event.getEntity().func_145782_y(), wolfArmorCapability.getHasChest(), wolfArmorCapability.getArmorItemStack()));
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<IWolfArmorCapability> {
        static final String NBT_TAG_HAS_CHEST = "hasChest";
        static final String NBT_TAG_SLOT = "slot";
        static final String NBT_TAG_INVENTORY = "inventory";
        static final String NBT_TAG_ARMOR_ITEM = "armorItem";

        @Nullable
        public NBTBase writeNBT(Capability<IWolfArmorCapability> capability, IWolfArmorCapability instance, EnumFacing side) {
            if (capability != Capabilities.CAPABILITY_WOLF_ARMOR) {
                return null;
            }
            return ((CapabilityWolfArmor)instance).serializeNBT();
        }

        public void readNBT(Capability<IWolfArmorCapability> capability, IWolfArmorCapability instance, EnumFacing side, NBTBase nbt) {
            if (capability != Capabilities.CAPABILITY_WOLF_ARMOR) {
                return;
            }
            if (nbt instanceof NBTTagCompound) {
                ((CapabilityWolfArmor)instance).deserializeNBT((NBTTagCompound)nbt);
            }
        }
    }
}

