/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.event;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.api.IWolfArmorCapability;
import com.attributestudios.wolfarmor.api.util.Capabilities;
import com.attributestudios.wolfarmor.common.ReflectionCache;
import com.attributestudios.wolfarmor.entity.ai.EntityAIWolfAutoEat;
import com.attributestudios.wolfarmor.entity.ai.EntityAIWolfHowl;
import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    @Deprecated
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityWolfArmoredJoinedWorld(@Nonnull EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Entity entity = event.getEntity();
            if (entity.getClass() == EntityWolfArmored.class) {
                WolfArmorMod.getLogger().warning("Replacing EntityWolfArmored with new capable wolf");
                EntityWolfArmored entityWolfArmored = (EntityWolfArmored)entity;
                EntityWolf entityWolf = new EntityWolf(world);
                IWolfArmorCapability wolfArmorCapability = (IWolfArmorCapability)entityWolf.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null);
                if (wolfArmorCapability == null) {
                    throw new RuntimeException("Failed to replace entity: Capabilities were not properly registered!");
                }
                InventoryBasic wolfInventory = entityWolfArmored.getInventory();
                InventoryBasic capabilityInventory = wolfArmorCapability.getInventory();
                for (int i = 0; i < wolfInventory.func_70302_i_(); ++i) {
                    ItemStack stack = wolfInventory.func_70301_a(i);
                    capabilityInventory.func_70299_a(i, stack);
                }
                if (entityWolfArmored.getHasArmor()) {
                    wolfArmorCapability.setArmorItemStack(entityWolfArmored.getArmorItemStack());
                }
                if (entityWolfArmored.getHasChest()) {
                    wolfArmorCapability.setHasChest(true);
                }
                NBTTagCompound compound = new NBTTagCompound();
                entityWolfArmored.func_189511_e(compound);
                entityWolf.func_82149_j((Entity)entityWolfArmored);
                entityWolf.func_70037_a(compound);
                world.func_72838_d((Entity)entityWolf);
                entityWolfArmored.func_70106_y();
                event.setCanceled(true);
            } else if (entity instanceof EntityWolf) {
                Field inventoryHandsDropChances = ReflectionCache.getField(EntityLiving.class, "inventoryHandsDropChances", "field_82174_bp");
                Field inventoryArmorDropChances = ReflectionCache.getField(EntityLiving.class, "inventoryArmorDropChances", "field_184655_bs");
                if (inventoryHandsDropChances != null) {
                    try {
                        Arrays.fill((float[])inventoryHandsDropChances.get(entity), 0.0f);
                    }
                    catch (IllegalAccessException e) {
                        WolfArmorMod.getLogger().error(e);
                    }
                }
                if (inventoryArmorDropChances != null) {
                    try {
                        Arrays.fill((float[])inventoryArmorDropChances.get(entity), 0.0f);
                    }
                    catch (IllegalAccessException e) {
                        WolfArmorMod.getLogger().error(e);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttachEntityAI(@Nonnull EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityWolf) {
            EntityWolf entity = (EntityWolf)event.getEntity();
            entity.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWolfHowl(entity));
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWolfAutoEat(entity));
        }
    }
}

