/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.loot;

import com.attributestudios.wolfarmor.api.util.Resources;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootHandler {
    private LootHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        LootTableList.func_186375_a((ResourceLocation)Resources.LOOT_TABLE_DUNGEON_CHEST_INJECT);
    }

    public static void init() {
        new LootHandler();
    }

    @SubscribeEvent
    public void dungeonLootLoad(LootTableLoadEvent event) {
        String chests;
        String name = event.getName().toString();
        if (name.startsWith(chests = "minecraft:chests/")) {
            String fileName;
            switch (fileName = name.substring(chests.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "nether_bridge": 
                case "simple_dungeon": 
                case "stronghold_corridor": 
                case "stronghold_crossing": 
                case "village_blacksmith": {
                    event.getTable().addPool(this.getInjectPool(Resources.LOOT_TABLE_DUNGEON_CHEST_INJECT));
                    break;
                }
            }
        }
    }

    private LootPool getInjectPool(ResourceLocation lootDungeonInject) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(lootDungeonInject)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(1.0f), "wolfarmor_injected_pool");
    }

    private LootEntry getInjectEntry(ResourceLocation lootDungeonInject) {
        return new LootEntryTable(lootDungeonInject, 1, 0, new LootCondition[0], "wolfarmor_injected_entry");
    }
}

