/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.network;

import com.attributestudios.wolfarmor.WolfArmorMod;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class MessageBase<T extends MessageBase<T>>
implements IMessage,
IMessageHandler<T, IMessage> {
    protected abstract void read(PacketBuffer var1) throws IOException;

    protected abstract void write(PacketBuffer var1) throws IOException;

    protected abstract IMessage process(EntityPlayer var1, Side var2);

    protected boolean isSideValid(Side side) {
        return true;
    }

    protected boolean isMainThreadRequired() {
        return true;
    }

    public IMessage onMessage(T message, MessageContext ctx) {
        if (!this.isSideValid(ctx.side)) {
            throw new RuntimeException(String.format("The side %s is not valid for packet %s", ctx.side.name(), message.getClass().getSimpleName()));
        }
        return this.isMainThreadRequired() ? this.enqueue(message, ctx) : ((MessageBase)message).process(WolfArmorMod.getProxy().getPlayerFromContext(ctx), ctx.side);
    }

    private IMessage enqueue(T message, MessageContext context) {
        IThreadListener thread = WolfArmorMod.getProxy().getThreadFromContext(context);
        thread.func_152344_a(new Runnable((MessageBase)message, context){
            final /* synthetic */ MessageBase val$message;
            final /* synthetic */ MessageContext val$context;
            {
                this.val$message = messageBase;
                this.val$context = messageContext;
            }

            @Override
            public void run() {
                this.val$message.process(WolfArmorMod.getProxy().getPlayerFromContext(this.val$context), this.val$context.side);
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.read(new PacketBuffer(buf));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("The packet %s failed to deserialize.", this.getClass().getSimpleName()), ex);
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            this.write(new PacketBuffer(buf));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("The packet %s failed to serialize.", this.getClass().getSimpleName()), ex);
        }
    }

    public static abstract class ServerMessageBase<T extends ServerMessageBase<T>>
    extends MessageBase<T> {
        @Override
        protected boolean isSideValid(Side side) {
            return side.isServer();
        }
    }

    public static abstract class ClientMessageBase<T extends ClientMessageBase<T>>
    extends MessageBase<T> {
        @Override
        protected boolean isSideValid(Side side) {
            return side.isClient();
        }
    }
}

