/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.network.packets;

import com.attributestudios.wolfarmor.api.IWolfArmorCapability;
import com.attributestudios.wolfarmor.api.util.Capabilities;
import com.attributestudios.wolfarmor.common.network.MessageBase;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class WolfArmorCapabilityDataMessage
extends MessageBase<WolfArmorCapabilityDataMessage> {
    private int entityId;
    private boolean hasChest;
    private ItemStack armorItemStack;

    public WolfArmorCapabilityDataMessage() {
    }

    public WolfArmorCapabilityDataMessage(int entityId, boolean hasChest, ItemStack armorItemStack) {
        this.entityId = entityId;
        this.hasChest = hasChest;
        this.armorItemStack = armorItemStack;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityId = buffer.readInt();
        this.hasChest = buffer.readBoolean();
        this.armorItemStack = buffer.func_150791_c();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.hasChest);
        buffer.func_150788_a(this.armorItemStack);
    }

    @Override
    protected IMessage process(EntityPlayer player, Side side) {
        IWolfArmorCapability capability;
        World world = player.func_130014_f_();
        Entity target = world.func_73045_a(this.entityId);
        if (target instanceof EntityWolf && (capability = (IWolfArmorCapability)target.getCapability(Capabilities.CAPABILITY_WOLF_ARMOR, null)) != null) {
            capability.setArmorItemStack(this.armorItemStack);
            capability.setHasChest(this.hasChest);
        }
        return null;
    }
}

