/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.compatibility;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.compatibility.loader.SophisticatedWolvesLoader;
import com.google.common.collect.Maps;
import java.util.HashMap;

public abstract class CompatibilityHelper {
    private static final HashMap<String, ICompatabilityLoader> loaders = Maps.newHashMap();

    private static void registerHelper(Class<? extends ICompatabilityLoader> loaderClass) {
        try {
            ICompatabilityLoader loader = loaderClass.newInstance();
            String modId = loader.getModId();
            if (loaders.containsKey(modId)) {
                throw new IllegalStateException(String.format("Mod ID %s already registered; loader registration skipped.", modId));
            }
            loaders.put(modId, loader);
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException e) {
            WolfArmorMod.getLogger().error(e);
        }
    }

    public static void init() {
        loaders.values().forEach(loader -> {
            try {
                loader.init();
            }
            catch (Exception e) {
                WolfArmorMod.getLogger().error(String.format("Skipped init compatibility for mod %s: %s", loader.getModId(), e.getMessage()));
            }
        });
    }

    public static void preInit() {
        loaders.values().forEach(loader -> {
            try {
                loader.preInit();
            }
            catch (Exception e) {
                WolfArmorMod.getLogger().error(String.format("Skipped pre-init compatibility for mod %s: %s", loader.getModId(), e.getMessage()));
            }
        });
    }

    public static void postInit() {
        loaders.values().forEach(loader -> {
            try {
                loader.postInit();
            }
            catch (Exception e) {
                WolfArmorMod.getLogger().error(String.format("Skipped post-init compatibility for mod %s: %s", loader.getModId(), e.getMessage()));
            }
        });
    }

    public static void loadComplete() {
        loaders.values().forEach(loader -> {
            try {
                loader.loadComplete();
            }
            catch (Exception e) {
                WolfArmorMod.getLogger().error(String.format("Skipped load complete compatibility for mod %s: %s", loader.getModId(), e.getMessage()));
            }
        });
    }

    static {
        CompatibilityHelper.registerHelper(SophisticatedWolvesLoader.class);
    }

    public static interface ICompatabilityLoader {
        public String getModId();

        public void init() throws Exception;

        public void preInit() throws Exception;

        public void postInit() throws Exception;

        public void loadComplete() throws Exception;
    }
}

