/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.entity.passive;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.api.IWolfArmorCapability;
import com.attributestudios.wolfarmor.common.capabilities.CapabilityWolfArmor;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

@Deprecated
public class EntityWolfArmored
extends EntityWolf
implements IInventoryChangedListener,
IWolfArmorCapability {
    private ContainerHorseChest inventory;
    private static final String NBT_TAG_HAS_CHEST = "hasChest";
    private static final String NBT_TAG_SLOT = "slot";
    private static final String NBT_TAG_INVENTORY = "inventory";
    private static final String NBT_TAG_ARMOR_ITEM = "armorItem";
    private static final int MAX_SIZE_INVENTORY = 7;
    private static final DataParameter<Boolean> HAS_CHEST = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityWolfArmored(@Nonnull World world) {
        super(world);
        this.inventoryInit();
    }

    private void inventoryInit() {
        ContainerHorseChest inventoryExisting = this.inventory;
        this.inventory = new ContainerHorseChest("container.wolfarmor.wolf", 7);
        String customName = this.func_95999_t();
        if (!customName.isEmpty()) {
            this.inventory.func_110133_a(customName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int numberOfItemsExisting = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < numberOfItemsExisting; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_CHEST, (Object)false);
        this.field_70180_af.func_187214_a(ARMOR_ITEM, (Object)ItemStack.field_190927_a);
    }

    public void func_70014_b(@Nonnull NBTTagCompound tags) {
        super.func_70014_b(tags);
        boolean entityHasChest = this.getHasChest();
        boolean entityHasArmor = this.getHasArmor();
        tags.func_74757_a(NBT_TAG_HAS_CHEST, entityHasChest);
        if (entityHasChest) {
            NBTTagList inventoryItemsTagList = new NBTTagList();
            for (byte slotIndex = 0; slotIndex < this.getInventory().func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = this.getInventory().func_70301_a((int)slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a(NBT_TAG_SLOT, slotIndex);
                stackInSlot.func_77955_b(slotTag);
                inventoryItemsTagList.func_74742_a((NBTBase)slotTag);
            }
            tags.func_74782_a(NBT_TAG_INVENTORY, (NBTBase)inventoryItemsTagList);
        }
        if (entityHasArmor) {
            ItemStack armorItem = this.getArmorItemStack();
            if (!armorItem.func_190926_b()) {
                tags.func_74782_a(NBT_TAG_ARMOR_ITEM, (NBTBase)armorItem.func_77955_b(new NBTTagCompound()));
            } else {
                tags.func_82580_o(NBT_TAG_ARMOR_ITEM);
            }
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound tags) {
        NBTTagCompound armorTags;
        super.func_70037_a(tags);
        boolean entityHasChest = tags.func_150297_b(NBT_TAG_HAS_CHEST, 1) && tags.func_74767_n(NBT_TAG_HAS_CHEST);
        this.setHasChest(entityHasChest);
        if (entityHasChest) {
            this.inventoryInit();
            NBTTagList inventoryItemsTagList = tags.func_150295_c(NBT_TAG_INVENTORY, 10);
            for (int tagIndex = 0; tagIndex < inventoryItemsTagList.func_74745_c(); ++tagIndex) {
                NBTTagCompound itemTag = inventoryItemsTagList.func_150305_b(tagIndex);
                byte slotIndex = itemTag.func_74771_c(NBT_TAG_SLOT);
                if (slotIndex >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slotIndex, new ItemStack(itemTag));
            }
        }
        if (!(armorTags = tags.func_74775_l(NBT_TAG_ARMOR_ITEM)).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    public void func_76316_a(@Nonnull IInventory inventory) {
        ItemStack armor = inventory.func_70301_a(0);
        this.setArmorItemStack(armor);
    }

    @Override
    public void equipArmor(@Nonnull ItemStack armorItemStack) {
        if (this.func_175448_a(armorItemStack)) {
            this.inventory.func_70299_a(0, armorItemStack);
        }
    }

    public boolean func_175448_a(@Nonnull ItemStack armorItemStack) {
        return CapabilityWolfArmor.isValidWolfArmor(armorItemStack) && (!this.getHasArmor() || armorItemStack.func_190926_b());
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return super.func_184645_a(player, hand);
    }

    public void func_82160_b(boolean killedByPlayer, int lootingModifier) {
        super.func_82160_b(killedByPlayer, lootingModifier);
    }

    public void func_70675_k(float damage) {
        super.func_70675_k(damage);
    }

    @Override
    public void dropInventoryContents() {
    }

    @Override
    public boolean getHasChest() {
        return WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && (Boolean)this.field_70180_af.func_187225_a(HAS_CHEST) != false;
    }

    @Override
    public void setHasChest(boolean value) {
        this.field_70180_af.func_187227_b(HAS_CHEST, (Object)value);
    }

    @Override
    public boolean getHasArmor() {
        return !this.getArmorItemStack().func_190926_b();
    }

    @Override
    @Nonnull
    public InventoryBasic getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventoryItem(int index, @Nonnull ItemStack itemStack) {
    }

    @Override
    @Nonnull
    public ItemStack getArmorItemStack() {
        ItemStack itemStack = (ItemStack)this.field_70180_af.func_187225_a(ARMOR_ITEM);
        if (!CapabilityWolfArmor.isValidWolfArmor(itemStack)) {
            this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        return itemStack;
    }

    @Override
    public void setArmorItemStack(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b() || !CapabilityWolfArmor.isValidWolfArmor(itemStack)) {
            return;
        }
        ItemStack currentArmor = this.getArmorItemStack();
        if (!currentArmor.func_190926_b()) {
            return;
        }
        this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)itemStack);
    }

    @Override
    public int getMaxSizeInventory() {
        return 7;
    }
}

