/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.mpm.LogWriter;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.Server;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        ByteBuf buf = event.getPacket().payload();
        try {
            this.handlePacket(buf, player, EnumPackets.values()[buf.readInt()]);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    private void handlePacket(ByteBuf buffer, EntityPlayerMP player, EnumPackets type) throws Exception {
        if (type == EnumPackets.PING) {
            ItemStack back;
            int version = buffer.readInt();
            if (version == MorePlayerModels.Version) {
                ModelData data = ModelData.get((EntityPlayer)player);
                data.readFromNBT(Server.readNBT(buffer));
                if (!player.field_70170_p.func_82736_K().func_82766_b("mpmAllowEntityModels")) {
                    data.entityClass = null;
                }
                data.save();
                Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
            }
            if (!(back = (ItemStack)player.field_71071_by.field_70462_a.get(0)).func_190926_b()) {
                Server.sendAssociatedData((Entity)player, EnumPackets.BACK_ITEM_UPDATE, player.func_110124_au(), back.func_77955_b(new NBTTagCompound()));
            }
            Server.sendData(player, EnumPackets.PING, MorePlayerModels.Version);
        } else if (type == EnumPackets.UPDATE_PLAYER_DATA) {
            ModelData data = ModelData.get((EntityPlayer)player);
            data.readFromNBT(Server.readNBT(buffer));
            if (!player.field_70170_p.func_82736_K().func_82766_b("mpmAllowEntityModels")) {
                data.entityClass = null;
            }
            data.save();
            Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
        } else if (type == EnumPackets.ANIMATION) {
            ModelData data;
            EnumAnimation animation = EnumAnimation.values()[buffer.readInt()];
            if (animation == EnumAnimation.SLEEPING_SOUTH) {
                float rotation;
                for (rotation = player.field_70177_z; rotation < 0.0f; rotation += 360.0f) {
                }
                while (rotation > 360.0f) {
                    rotation -= 360.0f;
                }
                int rotate = (int)((rotation + 45.0f) / 90.0f);
                if (rotate == 1) {
                    animation = EnumAnimation.SLEEPING_WEST;
                }
                if (rotate == 2) {
                    animation = EnumAnimation.SLEEPING_NORTH;
                }
                if (rotate == 3) {
                    animation = EnumAnimation.SLEEPING_EAST;
                }
            }
            if ((data = ModelData.get((EntityPlayer)player)).animationEquals(animation)) {
                animation = EnumAnimation.NONE;
            }
            Server.sendAssociatedData((Entity)player, EnumPackets.ANIMATION, new Object[]{player.func_110124_au(), animation});
            data.setAnimation(animation);
        }
    }
}

