/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.BooleanValue;
import org.orecruncher.lib.expression.Compiler;
import org.orecruncher.lib.expression.ExpressionException;
import org.orecruncher.lib.expression.Function;
import org.orecruncher.lib.expression.FunctionTable;
import org.orecruncher.lib.expression.LazyFunction;
import org.orecruncher.lib.expression.LazyVariant;
import org.orecruncher.lib.expression.NumberValue;
import org.orecruncher.lib.expression.Operator;
import org.orecruncher.lib.expression.OperatorTable;
import org.orecruncher.lib.expression.VariableTable;
import org.orecruncher.lib.expression.Variant;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

public final class Expression {
    public static final Variant PI = new NumberValue("PI", (float)Math.PI);
    public static final Variant e = new NumberValue("e", (float)Math.E);
    public static final Variant TRUE = new BooleanValue("TRUE", true);
    public static final Variant FALSE = new BooleanValue("FALSE", false);
    private static final OperatorTable builtInOperators = new OperatorTable();
    private static final FunctionTable builtInFunctions = new FunctionTable();
    private static final VariableTable builtInVariables = new VariableTable();
    private String expression = null;
    private List<String> rpn = null;
    private LazyVariant program;
    private final OperatorTable operators;
    private final FunctionTable functions;
    private final VariableTable variables;

    public static void addBuiltInOperator(Operator op) {
        builtInOperators.put(op.getOper(), op);
    }

    public static void addBuiltInFunction(LazyFunction func) {
        builtInFunctions.put(func.getName(), func);
    }

    public static void addBuiltInVariable(String name, LazyVariant number) {
        builtInVariables.put(name, number);
    }

    public static void addBuiltInVariable(@Nonnull Variant v) {
        builtInVariables.put(v.getName(), v);
    }

    public Expression(String expression) {
        this.expression = expression;
        this.operators = new OperatorTable(builtInOperators);
        this.functions = new FunctionTable(builtInFunctions);
        this.variables = new VariableTable(builtInVariables);
    }

    public Variant eval() {
        return this.getProgram().eval();
    }

    public LazyVariant getProgram() {
        if (this.program == null) {
            Compiler.Result result = new Compiler(this.operators, this.functions, this.variables).compile(this.expression);
            this.program = result.expression;
            this.rpn = result.rpn;
        }
        return this.program;
    }

    public List<String> getRPN() {
        if (this.rpn == null) {
            this.getProgram();
        }
        return this.rpn;
    }

    public String toRPN() {
        return String.join((CharSequence)" ", this.getRPN());
    }

    public Expression addVariable(@Nonnull Variant v) {
        this.variables.put(v.getName(), v);
        return this;
    }

    public Expression addVariables(@Nonnull List<? extends Variant> list) {
        list.forEach(v -> this.addVariable((Variant)v));
        return this;
    }

    public Expression addVariables(@Nonnull Map<String, ? extends Variant> map) {
        this.variables.putAll(map);
        return this;
    }

    @Nonnull
    public Expression addFunction(@Nonnull Function func) {
        this.functions.put(func.getName(), func);
        return this;
    }

    public Set<String> getDeclaredVariables() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public Set<String> getDeclaredOperators() {
        return Collections.unmodifiableSet(this.operators.keySet());
    }

    public Set<String> getDeclaredFunctions() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expression that = (Expression)o;
        if (this.expression == null) {
            return that.expression == null;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression == null ? 0 : this.expression.hashCode();
    }

    public String toString() {
        return this.toRPN();
    }

    static {
        Expression.addBuiltInOperator(new Operator("!", 20, false, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().asBoolean() ? FALSE : TRUE;
            }
        });
        Expression.addBuiltInOperator(new Operator("+", 20, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().add(operands[1].eval());
            }
        });
        Expression.addBuiltInOperator(new Operator("-", 20, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return new NumberValue(operands[0].eval().asNumber() - operands[1].eval().asNumber());
            }
        });
        Expression.addBuiltInOperator(new Operator("*", 30, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return new NumberValue(operands[0].eval().asNumber() * operands[1].eval().asNumber());
            }
        });
        Expression.addBuiltInOperator(new Operator("/", 30, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return new NumberValue(operands[0].eval().asNumber() / operands[1].eval().asNumber());
            }
        });
        Expression.addBuiltInOperator(new Operator("%", 30, true){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return new NumberValue(operands[0].eval().asNumber() % operands[1].eval().asNumber());
            }
        });
        Expression.addBuiltInOperator(new Operator("&&", 4, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().asBoolean() && operands[1].eval().asBoolean() ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("||", 2, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().asBoolean() || operands[1].eval().asBoolean() ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator(">", 10, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) > 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator(">=", 10, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) >= 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("<", 10, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) < 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("<=", 10, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) <= 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("=", 7, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) == 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("==", 7, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) == 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("!=", 7, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) != 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInOperator(new Operator("<>", 7, false){

            @Override
            public Variant eval(LazyVariant ... operands) {
                return operands[0].eval().compareTo(operands[1].eval()) != 0 ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInFunction(new Function("MATCH", 2){

            @Override
            public Variant eval(Variant ... parameters) {
                String input;
                String regex = parameters[0].asString();
                return Pattern.matches(regex, input = parameters[1].asString()) ? TRUE : FALSE;
            }
        });
        Expression.addBuiltInFunction(new Function("NOT", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                return parameters[0].asBoolean() ? FALSE : TRUE;
            }
        });
        Expression.addBuiltInFunction(new LazyFunction("IF", 3){

            @Override
            public LazyVariant lazyEval(LazyVariant ... lazyParams) {
                boolean isTrue = lazyParams[0].eval().asBoolean();
                return isTrue ? lazyParams[1] : lazyParams[2];
            }
        });
        Expression.addBuiltInFunction(new Function("RANDOM", 0){

            @Override
            public Variant eval(Variant ... parameters) {
                return new NumberValue(XorShiftRandom.current().nextFloat());
            }
        });
        Expression.addBuiltInFunction(new Function("SIN", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float d = MathStuff.sin(MathStuff.toRadians(parameters[0].asNumber()));
                return new NumberValue(d);
            }
        });
        Expression.addBuiltInFunction(new Function("COS", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float d = MathStuff.cos(MathStuff.toRadians(parameters[0].asNumber()));
                return new NumberValue(d);
            }
        });
        Expression.addBuiltInFunction(new Function("TAN", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float d = MathStuff.tan(MathStuff.toRadians(parameters[0].asNumber()));
                return new NumberValue(d);
            }
        });
        Expression.addBuiltInFunction(new Function("RAD", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float d = MathStuff.toRadians(parameters[0].asNumber());
                return new NumberValue(d);
            }
        });
        Expression.addBuiltInFunction(new Function("DEG", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float d = MathStuff.toDegrees(parameters[0].asNumber());
                return new NumberValue(d);
            }
        });
        Expression.addBuiltInFunction(new Function("MAX", -1){

            @Override
            public Variant eval(Variant ... parameters) {
                if (parameters.length == 0) {
                    throw new ExpressionException("MAX requires at least one parameter");
                }
                Variant max = null;
                for (Variant parameter : parameters) {
                    if (max != null && parameter.compareTo(max) <= 0) continue;
                    max = parameter;
                }
                return max;
            }
        });
        Expression.addBuiltInFunction(new Function("ONEOF", -1){

            @Override
            public Variant eval(Variant ... parameters) {
                if (parameters.length < 2) {
                    throw new ExpressionException("ONEOF requires at least two parameters");
                }
                Variant selector = parameters[0];
                for (int i = 1; i < parameters.length; ++i) {
                    if (selector.compareTo(parameters[i]) != 0) continue;
                    return TRUE;
                }
                return FALSE;
            }
        });
        Expression.addBuiltInFunction(new Function("MIN", -1){

            @Override
            public Variant eval(Variant ... parameters) {
                if (parameters.length == 0) {
                    throw new ExpressionException("MIN requires at least one parameter");
                }
                Variant min = null;
                for (Variant parameter : parameters) {
                    if (min != null && parameter.compareTo(min) >= 0) continue;
                    min = parameter;
                }
                return min;
            }
        });
        Expression.addBuiltInFunction(new Function("ABS", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                return new NumberValue(MathStuff.abs(parameters[0].asNumber()));
            }
        });
        Expression.addBuiltInFunction(new Function("ROUND", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float toRound = parameters[0].asNumber();
                return new NumberValue(Math.round(toRound));
            }
        });
        Expression.addBuiltInFunction(new Function("FLOOR", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float toRound = parameters[0].asNumber();
                return new NumberValue(Math.floor(toRound));
            }
        });
        Expression.addBuiltInFunction(new Function("CEILING", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float toRound = parameters[0].asNumber();
                return new NumberValue(Math.ceil(toRound));
            }
        });
        Expression.addBuiltInFunction(new Function("SQRT", 1){

            @Override
            public Variant eval(Variant ... parameters) {
                float x = parameters[0].asNumber();
                return new NumberValue(Math.sqrt(x));
            }
        });
        Expression.addBuiltInFunction(new Function("CLAMP", 3){

            @Override
            public Variant eval(Variant ... parameters) {
                float val = parameters[0].asNumber();
                float low = parameters[1].asNumber();
                float high = parameters[2].asNumber();
                return new NumberValue(MathStuff.clamp(val, low, high));
            }
        });
        Expression.addBuiltInVariable(e.getName(), e);
        Expression.addBuiltInVariable(PI.getName(), PI);
        Expression.addBuiltInVariable(TRUE.getName(), TRUE);
        Expression.addBuiltInVariable(FALSE.getName(), FALSE);
    }
}

