/*
 * Decompiled with CFR 0.152.
 */
package astikoor.entity;

import astikoor.Astikoor;
import astikoor.config.ModConfig;
import astikoor.entity.EntityCart;
import astikoor.handler.PacketHandler;
import astikoor.init.ModItems;
import astikoor.packets.CPacketCargoLoad;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityCargoCart
extends EntityCart
implements IInventoryChangedListener {
    public int load;
    public InventoryBasic cargo;
    protected IItemHandler itemHandler = null;

    public EntityCargoCart(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.4f);
        this.field_70138_W = 1.2f;
        this.offsetFactor = 2.4;
    }

    @Override
    public boolean canPull(Entity pullingIn) {
        String[] canPullArray = ModConfig.cargocart.canPull;
        for (int i = 0; i < canPullArray.length; ++i) {
            if (!canPullArray[i].equals(pullingIn instanceof EntityPlayer ? "minecraft:player" : EntityList.func_191301_a((Entity)pullingIn).toString())) continue;
            return true;
        }
        return false;
    }

    public int getLoad() {
        return this.load;
    }

    public void setLoad(int loadIn) {
        this.load = loadIn;
    }

    @Override
    public void onDestroyed(DamageSource source) {
        if (!source.func_180136_u()) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, new ItemStack(ModItems.cargocart)));
        }
        for (int i = 0; i < this.cargo.func_70302_i_(); ++i) {
            ItemStack stack = this.cargo.func_70301_a(i);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, stack));
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            player.openGui((Object)Astikoor.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
        } else if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public double func_70042_X() {
        return 0.62;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vec3d vec3d = new Vec3d(-0.68, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + vec3d.field_72449_c);
        }
    }

    @Override
    protected void func_70088_a() {
        InventoryBasic inventory = this.cargo;
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.cargo.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.cargo.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.cargo = new InventoryBasic(this.func_70005_c_(), true, 54);
        this.cargo.func_110134_a((IInventoryChangedListener)this);
        this.itemHandler = new InvWrapper((IInventory)this.cargo);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            this.cargo.func_70299_a(i, new ItemStack(nbttaglist.func_150305_b(i)));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.cargo.func_70302_i_(); ++i) {
            ItemStack itemstack = this.cargo.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_76316_a(IInventory invBasic) {
        if (!this.field_70170_p.field_72995_K) {
            int lastload = this.load;
            int tempload = 0;
            for (int i = 0; i < this.cargo.func_70302_i_(); ++i) {
                if (this.cargo.func_70301_a(i).func_190926_b()) continue;
                ++tempload;
            }
            this.load = tempload > 31 ? 4 : (tempload > 16 ? 3 : (tempload > 8 ? 2 : (tempload > 3 ? 1 : 0)));
            if (this.load != lastload) {
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, PacketHandler.INSTANCE.getPacketFrom((IMessage)new CPacketCargoLoad(this.load, this.func_145782_y())));
            }
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

