/*
 * Decompiled with CFR 0.152.
 */
package astikoor.entity;

import astikoor.handler.PacketHandler;
import astikoor.packets.CPacketEntityCartUpdate;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCart
extends Entity {
    protected Entity pulling;
    private float wheelrot;
    private double factor;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private int lasthit;
    private int hitcount;
    private final Set<EntityAITasks.EntityAITaskEntry> TASKENTRIES = new LinkedHashSet<EntityAITasks.EntityAITaskEntry>();
    protected double offsetFactor;

    public EntityCart(World worldIn) {
        super(worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_189652_ae()) {
            this.field_70181_x += -0.04;
        }
        if (this.pulling != null) {
            if (!this.field_70170_p.field_72995_K && this.shouldRemovePulling()) {
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, PacketHandler.INSTANCE.getPacketFrom((IMessage)new CPacketEntityCartUpdate(this.pulling.func_145782_y(), this.func_145782_y())));
                this.setPulling(null);
                return;
            }
            Vec3d targetVec = this.getTargetVec();
            this.handleRotation(targetVec);
            double dRotation = this.field_70126_B - this.field_70177_z;
            if (dRotation < -180.0) {
                this.field_70126_B += 360.0f;
            } else if (dRotation >= 180.0) {
                this.field_70126_B -= 360.0f;
            }
            Vec3d moveVec = new Vec3d(targetVec.field_72450_a - this.field_70165_t - this.func_70040_Z().field_72450_a * this.offsetFactor, 0.0, targetVec.field_72449_c - this.field_70161_v - this.func_70040_Z().field_72449_c * this.offsetFactor);
            this.factor = -Math.sqrt(moveVec.field_72450_a * moveVec.field_72450_a + moveVec.field_72449_c * moveVec.field_72449_c);
            this.field_70159_w = moveVec.field_72450_a;
            this.field_70179_y = moveVec.field_72449_c;
            this.tickLerp();
            if (moveVec.func_178788_d(this.func_70040_Z()).func_72433_c() > 1.0) {
                this.factor = -this.factor;
            }
        } else {
            this.factor = 0.0;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.collideWithNearbyEntities();
    }

    public void handleRotation(Vec3d targetVecIn) {
        this.field_70177_z = (float)Math.toDegrees(-Math.atan2(targetVecIn.field_72450_a - this.field_70165_t, targetVecIn.field_72449_c - this.field_70161_v));
    }

    public Vec3d getTargetVec() {
        return new Vec3d(this.pulling.field_70165_t, this.pulling.field_70163_u, this.pulling.field_70161_v);
    }

    protected boolean shouldRemovePulling() {
        RayTraceResult result;
        if (this.pulling != null && (result = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v), new Vec3d(this.pulling.field_70165_t, this.pulling.field_70163_u + (double)(this.field_70131_O / 2.0f), this.pulling.field_70161_v), false, true, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            return true;
        }
        return this.pulling.field_70128_L;
    }

    public boolean canPull(Entity pullingIn) {
        return true;
    }

    public Entity getPulling() {
        return this.pulling;
    }

    public void setPulling(Entity entityIn) {
        if (this.pulling == null || entityIn == null) {
            if (entityIn instanceof EntityLiving) {
                for (EntityAITasks.EntityAITaskEntry task : ((EntityLiving)entityIn).field_70714_bg.field_75782_a) {
                    this.TASKENTRIES.add(task);
                    task.field_75733_a.func_75251_c();
                }
                for (EntityAITasks.EntityAITaskEntry task : this.TASKENTRIES) {
                    ((EntityLiving)entityIn).field_70714_bg.func_85156_a(task.field_75733_a);
                }
            } else if (this.pulling instanceof EntityLiving) {
                for (EntityAITasks.EntityAITaskEntry task : this.TASKENTRIES) {
                    ((EntityLiving)this.pulling).field_70714_bg.field_75782_a.add(task);
                }
                this.TASKENTRIES.clear();
            }
            this.pulling = entityIn;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getWheelRotation() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            this.factor = 0.0;
        }
        this.wheelrot = (float)((double)this.wheelrot - (double)0.12f * this.factor);
        return this.wheelrot;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void collideWithNearbyEntities() {
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntitySelectors.func_188442_a((Entity)this))) {
            double dx = entity.field_70165_t - this.field_70165_t;
            double dz = entity.field_70161_v - this.field_70161_v;
            double delta = MathHelper.func_76132_a((double)dx, (double)dz);
            if (!(delta >= 0.01)) continue;
            delta = MathHelper.func_76133_a((double)delta);
            dx /= delta;
            dz /= delta;
            double d3 = 1.0 / delta;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            dx *= d3;
            dz *= d3;
            dx *= 0.05;
            dz *= 0.05;
            dx *= (double)(1.0f - this.field_70144_Y);
            dz *= (double)(1.0f - this.field_70144_Y);
            if (entity.func_184207_aI()) continue;
            entity.func_70024_g(dx, 0.0, dz);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70128_L) {
            if (source.func_180136_u()) {
                this.func_70106_y();
            } else {
                this.lasthit = this.field_70173_aa;
                this.hitcount = this.lasthit >= this.field_70173_aa - 20 ? ++this.hitcount : 0;
                if (this.hitcount == 10) {
                    this.func_70106_y();
                }
            }
            if (this.field_70128_L) {
                this.setPulling(null);
                if (!this.field_70170_p.field_72995_K) {
                    this.onDestroyed(source);
                }
            }
        }
        return true;
    }

    public void onDestroyed(DamageSource source) {
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.pulling.func_184186_bw()) {
            double dx = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double dy = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double dz = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.func_70107_b(dx, dy, dz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
        }
    }
}

