/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.dropcreators;

import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DropCreatorFruitLogProduct
extends DropCreator {
    private final TreeFamilyPHC treeFamily;
    private final float yieldPerLog;

    public DropCreatorFruitLogProduct(TreeFamilyPHC treeFamily) {
        this(treeFamily, 1.0f);
    }

    public DropCreatorFruitLogProduct(TreeFamilyPHC treeFamily, float yieldPerLog) {
        super(new ResourceLocation("dynamictrees", "fruitlog"));
        this.treeFamily = treeFamily;
        this.yieldPerLog = yieldPerLog;
    }

    public List<ItemStack> getLogsDrop(World world, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, float volume) {
        Block primLogBlock = this.treeFamily.getPrimitiveLog().func_177230_c();
        if (primLogBlock instanceof BlockPamFruitLog) {
            BlockPamFruitLog fruitLog = (BlockPamFruitLog)primLogBlock;
            Item fruit = fruitLog.getFruitItem();
            int maxStackSize = fruit.func_77639_j();
            for (int numFruits = (int)(volume * this.yieldPerLog); numFruits > 0; numFruits -= maxStackSize) {
                dropList.add(new ItemStack(fruit, numFruits >= maxStackSize ? maxStackSize : numFruits));
            }
        }
        return dropList;
    }
}

