/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.proxy;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.ModTrees;
import com.ferreusveritas.dynamictreesphc.proxy.CommonProxy;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    public void registerColorHandlers() {
        try {
            ResourceLocation loc = new ResourceLocation("dynamictreesphc", "models/item/seedcolors.json");
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Gson gson = new Gson();
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            JsonObject json = je.getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                String speciesName = (String)entry.getKey();
                Species species = ModTrees.phcSpecies.get(speciesName);
                if (species == null) continue;
                Seed seed = species.getSeed();
                JsonArray colors = ((JsonElement)entry.getValue()).getAsJsonArray();
                final ArrayList colorArray = new ArrayList(4);
                colors.forEach(i -> colorArray.add(Integer.parseInt(i.getAsString(), 16)));
                if (colors == null) continue;
                ModelHelper.regColorHandler((Item)seed, (IItemColor)new IItemColor(){

                    public int func_186726_a(ItemStack stack, int tintIndex) {
                        return tintIndex >= 0 && tintIndex < colorArray.size() ? (Integer)colorArray.get(tintIndex) : 0xFFFFFF;
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int magenta = 0xFF00FF;
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"dynamictreesphc").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }
}

