/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.dropcreators.DropCreatorFruitLogProduct;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeMaple
extends TreeFamilyPHC {
    public static final String speciesName = "maple";

    public TreeMaple() {
        super(new ResourceLocation("dynamictreesphc", speciesName));
        this.setPrimitiveLog(ModBlocks.primMapleLog.func_176223_P());
        ModBlocks.mapleLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreeMapleSpecies(this));
        this.getCommonSpecies().generateSeed();
    }

    public class TreeMapleSpecies
    extends Species {
        public TreeMapleSpecies(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.mapleLeavesProperties);
            this.setBasicGrowingParameters(0.15f, 14.0f, 4, 4, 1.05f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruitLogProduct((TreeFamilyPHC)treeFamily));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }
    }
}

