/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.dropcreators.DropCreatorFruitLogProduct;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreePaperBark
extends TreeFamilyPHC {
    public static final String speciesName = "paperbark";

    public TreePaperBark() {
        super(new ResourceLocation("dynamictreesphc", speciesName));
        this.setPrimitiveLog(ModBlocks.primPaperBarkLog.func_176223_P());
        ModBlocks.paperBarkLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreePaperBarkSpecies(this));
        this.getCommonSpecies().generateSeed();
    }

    @Override
    public List<Item> getRegisterableItems(List<Item> itemList) {
        itemList.add((Item)new ItemBlock((Block)this.getDynamicBranch()).setRegistryName(this.getDynamicBranch().getRegistryName()));
        return itemList;
    }

    public class TreePaperBarkSpecies
    extends Species {
        public TreePaperBarkSpecies(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.paperBarkLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 10.0f, this.getUpProbability(), this.getLowestBranchHeight(), 1.0f);
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruitLogProduct((TreeFamilyPHC)treeFamily, 1.5f));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }
    }
}

