/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.core;

import familiarfauna.core.CommonProxy;
import familiarfauna.entities.EntityButterfly;
import familiarfauna.entities.EntityDeer;
import familiarfauna.entities.EntityDragonfly;
import familiarfauna.entities.EntityPixie;
import familiarfauna.entities.EntitySnail;
import familiarfauna.entities.EntityTurkey;
import familiarfauna.entities.render.RenderButterfly;
import familiarfauna.entities.render.RenderDeer;
import familiarfauna.entities.render.RenderDragonfly;
import familiarfauna.entities.render.RenderPixie;
import familiarfauna.entities.render.RenderSnail;
import familiarfauna.entities.render.RenderTurkey;
import familiarfauna.particle.EntityBluePixieTrailFX;
import familiarfauna.particle.EntityPinkPixieTrailFX;
import familiarfauna.particle.EntityPurplePixieTrailFX;
import familiarfauna.particle.FFParticleTypes;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    public static ResourceLocation particleTexturesLocation = new ResourceLocation("familiarfauna:textures/particles/particles.png");

    @Override
    public void registerRenderers() {
        ClientProxy.registerEntityRenderer(EntityButterfly.class, RenderButterfly.class);
        ClientProxy.registerEntityRenderer(EntityDragonfly.class, RenderDragonfly.class);
        ClientProxy.registerEntityRenderer(EntityPixie.class, RenderPixie.class);
        ClientProxy.registerEntityRenderer(EntitySnail.class, RenderSnail.class);
        ClientProxy.registerEntityRenderer(EntityDeer.class, RenderDeer.class);
        ClientProxy.registerEntityRenderer(EntityTurkey.class, RenderTurkey.class);
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        if (item != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("familiarfauna:" + name)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("familiarfauna:" + name, "inventory"));
        }
    }

    @Override
    public void spawnParticle(FFParticleTypes type, World parWorld, double x, double y, double z, Object ... info) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Particle entityFx = null;
        switch (type) {
            case PINK_PIXIE_TRAIL: {
                entityFx = new EntityPinkPixieTrailFX(parWorld, x, y, z, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
            case BLUE_PIXIE_TRAIL: {
                entityFx = new EntityBluePixieTrailFX(parWorld, x, y, z, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
            case PURPLE_PIXIE_TRAIL: {
                entityFx = new EntityPurplePixieTrailFX(parWorld, x, y, z, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
        }
        if (entityFx != null) {
            minecraft.field_71452_i.func_78873_a(entityFx);
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

