/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;

public final class ModelDynBlockArmor
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation("blockarmor:block_armor", "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5314375f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, java.util.function.Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedDynBlockArmor(format);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelDynBlockArmor process(ImmutableMap<String, String> customData) {
        return this;
    }

    public ModelDynBlockArmor retexture(ImmutableMap<String, String> textures) {
        return this;
    }

    private static final class BakedDynBlockArmor
    implements IBakedModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private ImmutableList<BakedQuad> quads;

        public BakedDynBlockArmor(VertexFormat format) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)new TRSRTransformation(new Vector3f(0.25f, 0.375f, 0.25f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)new TRSRTransformation(new Vector3f(1.0f, 0.8125f, 1.4375f), new Quat4f(0.0f, 1.0f, 0.0f, -4.371139E-8f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new TRSRTransformation(new Vector3f(0.910625f, 0.24816513f, 0.40617055f), new Quat4f(-0.15304594f, -0.6903456f, 0.15304594f, 0.6903456f), new Vector3f(0.68000007f, 0.68000007f, 0.68f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TRSRTransformation(new Vector3f(0.910625f, 0.24816513f, 0.40617055f), new Quat4f(-0.15304594f, -0.6903456f, 0.15304594f, 0.6903456f), new Vector3f(0.68000007f, 0.68000007f, 0.68f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TRSRTransformation(new Vector3f(0.225f, 0.4125f, 0.2875f), new Quat4f(0.0f, 0.0f, 0.0f, 0.99999994f), new Vector3f(0.55f, 0.55f, 0.55f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TRSRTransformation(new Vector3f(0.225f, 0.4125f, 0.2875f), new Quat4f(0.0f, 0.0f, 0.0f, 0.99999994f), new Vector3f(0.55f, 0.55f, 0.55f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            ImmutableMap transformMap = builder.build();
            this.transforms = Maps.immutableEnumMap((Map)transformMap);
        }

        public ItemOverrideList func_188617_f() {
            return BakedDynBlockArmorOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    public static final class BakedDynBlockArmorOverrideHandler
    extends ItemOverrideList {
        private static HashMap<Item, ImmutableList<BakedQuad>> itemQuadsMap = Maps.newHashMap();
        public static final BakedDynBlockArmorOverrideHandler INSTANCE = new BakedDynBlockArmorOverrideHandler();

        private BakedDynBlockArmorOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public static int createInventoryIcons() {
            itemQuadsMap = Maps.newHashMap();
            int numIcons = 0;
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            builder2.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)new TRSRTransformation(new Vector3f(0.25f, 0.375f, 0.25f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder2.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)new TRSRTransformation(new Vector3f(1.0f, 0.8125f, 1.4375f), new Quat4f(0.0f, 1.0f, 0.0f, -4.371139E-8f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder2.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new TRSRTransformation(new Vector3f(0.910625f, 0.24816513f, 0.40617055f), new Quat4f(-0.15304594f, -0.6903456f, 0.15304594f, 0.6903456f), new Vector3f(0.68000007f, 0.68000007f, 0.68f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder2.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TRSRTransformation(new Vector3f(0.910625f, 0.24816513f, 0.40617055f), new Quat4f(-0.15304594f, -0.6903456f, 0.15304594f, 0.6903456f), new Vector3f(0.68000007f, 0.68000007f, 0.68f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder2.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TRSRTransformation(new Vector3f(0.225f, 0.4125f, 0.2875f), new Quat4f(0.0f, 0.0f, 0.0f, 0.99999994f), new Vector3f(0.55f, 0.55f, 0.55f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            builder2.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TRSRTransformation(new Vector3f(0.225f, 0.4125f, 0.2875f), new Quat4f(0.0f, 0.0f, 0.0f, 0.99999994f), new Vector3f(0.55f, 0.55f, 0.55f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
            ImmutableMap transformMap = builder2.build();
            for (ArmorSet set : ArmorSet.allSets) {
                ItemBlockArmor[] armor;
                for (ItemBlockArmor item : armor = new ItemBlockArmor[]{set.helmet, set.chestplate, set.leggings, set.boots}) {
                    TextureAtlasSprite sprite = ArmorSet.getSprite(item);
                    if (sprite == null) {
                        BlockArmor.logger.warn("Missing sprite for: " + new ItemStack((Item)item).func_82833_r());
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    SimpleModelState state = new SimpleModelState(transformMap);
                    TRSRTransformation transform = TRSRTransformation.identity();
                    state = new ModelStateComposition((IModelState)state, (IModelState)transform);
                    VertexFormat format = DefaultVertexFormats.field_176599_b;
                    String armorType = "";
                    EntityEquipmentSlot slot = item.field_77881_a;
                    if (slot == EntityEquipmentSlot.HEAD) {
                        armorType = "helmet";
                    } else if (slot == EntityEquipmentSlot.CHEST) {
                        armorType = "chestplate";
                    } else if (slot == EntityEquipmentSlot.LEGS) {
                        armorType = "leggings";
                    } else if (slot == EntityEquipmentSlot.FEET) {
                        armorType = "boots";
                    }
                    ResourceLocation baseLocation = new ResourceLocation("blockarmor:items/icons/block_armor_" + armorType + "_base");
                    IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)baseLocation)).bake((IModelState)state, format, (java.util.function.Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                        public TextureAtlasSprite apply(ResourceLocation location) {
                            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                        }
                    });
                    builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
                    int color = ArmorSet.getColor(item);
                    if (color != -1) {
                        float r = (float)(color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(color >> 0 & 0xFF) / 255.0f;
                        color = new Color(r, g, b).getRGB();
                    }
                    String templateLocation = new ResourceLocation("blockarmor:items/icons/block_armor_" + armorType + "1_template").toString();
                    TextureAtlasSprite templateTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(templateLocation);
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)templateTexture, (TextureAtlasSprite)sprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)color));
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)templateTexture, (TextureAtlasSprite)sprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)color));
                    templateLocation = new ResourceLocation("blockarmor:items/icons/block_armor_" + armorType + "2_template").toString();
                    templateTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(templateLocation);
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)templateTexture, (TextureAtlasSprite)sprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)color));
                    builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)templateTexture, (TextureAtlasSprite)sprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)color));
                    String coverLocation = new ResourceLocation("blockarmor:items/icons/block_armor_" + armorType + "_cover").toString();
                    TextureAtlasSprite coverTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(coverLocation);
                    builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)coverTexture, (EnumFacing)EnumFacing.NORTH, (int)-1));
                    builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5314375f, (TextureAtlasSprite)coverTexture, (EnumFacing)EnumFacing.SOUTH, (int)-1));
                    itemQuadsMap.put((Item)item, (ImmutableList<BakedQuad>)builder.build());
                    ++numIcons;
                }
            }
            return numIcons;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (originalModel instanceof BakedDynBlockArmor && ((BakedDynBlockArmor)originalModel).quads == null) {
                ((BakedDynBlockArmor)originalModel).quads = BakedDynBlockArmorOverrideHandler.itemQuadsMap.get(stack.func_77973_b());
            }
            return originalModel;
        }
    }

    public static enum LoaderDynBlockArmor implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("blockarmor") && (modelLocation.func_110623_a().contains("helmet") || modelLocation.func_110623_a().contains("chestplate") || modelLocation.func_110623_a().contains("leggings") || modelLocation.func_110623_a().contains("boots"));
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return new ModelDynBlockArmor();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

