/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twopiradians.blockArmor.client.model.ModelBlockArmor;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.command.CommandDev;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class ItemBlockArmor
extends ItemArmor {
    public ArmorSet set;

    public ItemBlockArmor(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot equipmentSlot, ArmorSet set) {
        super(material, renderIndex, equipmentSlot);
        this.set = set;
        this.func_77637_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        TextureAtlasSprite sprite = ArmorSet.getSprite(this);
        String texture = sprite.func_94215_i() + ".png";
        int index = texture.indexOf(":");
        texture = texture.substring(0, index + 1) + "textures/" + texture.substring(index + 1);
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped oldModel) {
        TextureAtlasSprite sprite = ArmorSet.getSprite(this);
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b() * sprite.func_110970_k();
        boolean isTranslucent = this.set.isTranslucent;
        int currentFrame = ArmorSet.getCurrentAnimationFrame(this);
        int nextFrame = ArmorSet.getNextAnimationFrame(this);
        int color = ArmorSet.getColor(this);
        float alpha = ArmorSet.getAlpha(this);
        ModelBlockArmor model = (ModelBlockArmor)((Object)BlockArmor.proxy.getBlockArmorModel(height, width, currentFrame, nextFrame, slot));
        model.translucent = isTranslucent;
        model.color = color;
        model.alpha = alpha;
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        if (!this.set.isEnabled()) {
            return;
        }
        subItems.add(new ItemStack(itemIn));
    }

    public String func_77653_i(ItemStack stack) {
        return ArmorSet.getItemStackDisplayName(stack, this.field_77881_a);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> map = this.func_111205_h(slot);
        if (slot != this.field_77881_a) {
            return map;
        }
        for (SetEffect effect : this.set.setEffects) {
            map = effect.getAttributeModifiers(map, slot, stack);
        }
        return map;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77948_v()) {
            return EnumRarity.RARE;
        }
        if (!this.set.setEffects.isEmpty()) {
            return EnumRarity.UNCOMMON;
        }
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("devSpawned")) {
            tooltip.add(TextFormatting.DARK_PURPLE + "" + TextFormatting.BOLD + "Dev Spawned");
        }
        if (!this.set.setEffects.isEmpty() && this.set.setEffects.get(0).isEnabled()) {
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.ITALIC + "" + TextFormatting.GOLD + "Set Effects: " + TextFormatting.ITALIC + "(requires " + Config.piecesForSet + (Config.piecesForSet == 4 ? "" : "+") + " pieces to be worn)");
            }
            for (SetEffect effect : this.set.setEffects) {
                tooltip = effect.addInformation(stack, GuiScreen.func_146272_n(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltip, flagIn);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (stack.func_190926_b() || !this.set.isEnabled() && !world.field_72995_K & entity instanceof EntityPlayer || !world.field_72995_K && entity instanceof EntityPlayer && stack.func_77942_o() && stack.func_77978_p().func_74764_b("devSpawned") && !CommandDev.DEVS.contains(entity.getPersistentID()) && ((EntityPlayer)entity).field_71071_by.func_70301_a(slot) == stack) {
            if (((EntityPlayer)entity).field_71071_by.func_70301_a(slot) == stack) {
                ((EntityPlayer)entity).field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        for (SetEffect effect : this.set.setEffects) {
            effect.onUpdate(stack, world, entity, slot, isSelected);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!this.set.isEnabled() && !entityItem.field_70170_p.field_72995_K || !entityItem.field_70170_p.field_72995_K && entityItem != null && entityItem.func_92059_d() != null && entityItem.func_92059_d().func_77942_o() && entityItem.func_92059_d().func_77978_p().func_74764_b("devSpawned")) {
            entityItem.func_70106_y();
            return true;
        }
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b() || !this.set.isEnabled() && !world.field_72995_K || !world.field_72995_K && stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("devSpawned") && !CommandDev.DEVS.contains(player.getPersistentID()) && player.func_184582_a(this.field_77881_a) == stack) {
            player.func_184201_a(this.field_77881_a, ItemStack.field_190927_a);
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        for (SetEffect effect : this.set.setEffects) {
            if (!ArmorSet.getWornSetEffects((EntityLivingBase)player).contains(effect)) continue;
            effect.onArmorTick(world, player, stack);
        }
    }
}

