/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.item;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.item.ItemBlockArmor;
import twopiradians.blockArmor.common.recipe.RecipeBlockArmor;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class ModItems {
    public static ArrayList<ItemBlockArmor> allArmors = new ArrayList();

    public static void registerRenders() {
        for (ItemBlockArmor item : allArmors) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)item, 0, new ModelResourceLocation("blockarmor:" + item.func_77658_a().substring(5), "inventory"));
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ArmorSet.postInit();
            SetEffect.postInit();
            Config.postInit(BlockArmor.configFile);
            int vanillaItems = 0;
            int moddedItems = 0;
            for (ArmorSet set : ArmorSet.allSets) {
                if (Config.disabledSets.contains(set)) continue;
                String registryName = ArmorSet.getItemStackRegistryName(set.stack);
                set.helmet = RegistrationHandler.register((IForgeRegistry<Item>)event.getRegistry(), new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.HEAD, set), registryName + "_helmet", true);
                set.chestplate = RegistrationHandler.register((IForgeRegistry<Item>)event.getRegistry(), new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.CHEST, set), registryName + "_chestplate", true);
                set.leggings = RegistrationHandler.register((IForgeRegistry<Item>)event.getRegistry(), new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.LEGS, set), registryName + "_leggings", true);
                set.boots = RegistrationHandler.register((IForgeRegistry<Item>)event.getRegistry(), new ItemBlockArmor(set.material, 0, EntityEquipmentSlot.FEET, set), registryName + "_boots", true);
                if (set.isFromModdedBlock) {
                    moddedItems += 4;
                } else {
                    vanillaItems += 4;
                }
                ArrayList<IForgeRegistryEntry> recipes = new ArrayList<IForgeRegistryEntry>();
                ItemStack A = set.stack;
                NonNullList helmetRecipe = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A})});
                NonNullList armorRecipe = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A})});
                NonNullList legsRecipe = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A})});
                NonNullList bootsRecipe = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{A})});
                recipes.add(new RecipeBlockArmor(set, "Block Armor", 3, 2, (NonNullList<Ingredient>)helmetRecipe, new ItemStack((Item)set.helmet)).setRegistryName(set.helmet.getRegistryName()));
                recipes.add(new RecipeBlockArmor(set, "Block Armor", 3, 3, (NonNullList<Ingredient>)armorRecipe, new ItemStack((Item)set.chestplate)).setRegistryName(set.chestplate.getRegistryName()));
                recipes.add(new RecipeBlockArmor(set, "Block Armor", 3, 3, (NonNullList<Ingredient>)legsRecipe, new ItemStack((Item)set.leggings)).setRegistryName(set.leggings.getRegistryName()));
                recipes.add(new RecipeBlockArmor(set, "Block Armor", 3, 2, (NonNullList<Ingredient>)bootsRecipe, new ItemStack((Item)set.boots)).setRegistryName(set.boots.getRegistryName()));
                for (IRecipe iRecipe : recipes) {
                    if (ForgeRegistries.RECIPES.containsValue((IForgeRegistryEntry)iRecipe)) continue;
                    ForgeRegistries.RECIPES.register((IForgeRegistryEntry)iRecipe);
                }
            }
            for (ArmorSet set : Config.disabledSets) {
                ArmorSet.allSets.remove(set);
            }
            BlockArmor.logger.info("Generated " + vanillaItems + " Block Armor items from Vanilla Blocks");
            if (moddedItems > 0) {
                BlockArmor.logger.info("Generated " + moddedItems + " Block Armor items from Modded Blocks");
            }
            Config.syncConfig();
        }

        private static ItemBlockArmor register(IForgeRegistry<Item> registry, ItemBlockArmor armor, String itemName, boolean isFromModdedBlock) {
            allArmors.add(armor);
            armor.setRegistryName("blockarmor", itemName);
            armor.func_77655_b(armor.getRegistryName().func_110623_a());
            registry.register((IForgeRegistryEntry)armor);
            return armor;
        }
    }
}

