/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.block.BlockMovingLightSource;
import twopiradians.blockArmor.common.block.ModBlocks;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectIlluminated
extends SetEffect {
    private int lightLevel;

    public SetEffectIlluminated(int lightLevel) {
        this.lightLevel = Math.min(lightLevel, 15);
        this.color = TextFormatting.GOLD;
        this.description = "Produces light level " + this.lightLevel;
        this.usesButton = true;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && !world.field_72995_K && BlockArmor.key.isKeyDown(player) && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            boolean deactivated = !stack.func_77978_p().func_74767_n("deactivated");
            stack.func_77978_p().func_74757_a("deactivated", deactivated);
            player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "[Block Armor] " + TextFormatting.ITALIC + "Illuminated set effect " + (deactivated ? TextFormatting.RED + "" + TextFormatting.ITALIC + "disabled." : TextFormatting.GREEN + "" + TextFormatting.ITALIC + "enabled."), new Object[0]));
            this.setCooldown(player, 10);
        }
        if (ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && !world.field_72995_K && world.func_175623_d(player.func_180425_c().func_177984_a()) && world.func_175642_b(EnumSkyBlock.BLOCK, player.func_180425_c().func_177984_a()) < this.lightLevel && !stack.func_77978_p().func_74767_n("deactivated")) {
            world.func_175656_a(player.func_180425_c().func_177984_a(), ModBlocks.MOVING_LIGHT_SOURCE.func_176223_P().func_177226_a(BlockMovingLightSource.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.lightLevel)));
        }
    }

    @Override
    protected SetEffect create(Block block) {
        return new SetEffectIlluminated(block.func_176223_P().func_185906_d());
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        try {
            int lightLevel = block.func_176223_P().func_185906_d();
            if (lightLevel > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

