/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectImmovable
extends SetEffect {
    protected SetEffectImmovable(double knockbackResistance) {
        this.color = TextFormatting.GRAY;
        this.description = "Gives " + (int)(knockbackResistance * 100.0) + "% Knockback Resistance";
        this.attributeModifiers.add(new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, SharedMonsterAttributes.field_111266_c.func_111108_a(), knockbackResistance, 0));
    }

    @Override
    protected SetEffect create(Block block) {
        double hardness = block.func_176195_g(block.func_176223_P(), null, BlockPos.field_177992_a);
        hardness = hardness == -1.0 ? 100.0 : Math.max(25.0, Math.min(100.0, hardness * 1.5));
        return new SetEffectImmovable(hardness / 100.0);
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        double hardness = 0.0;
        try {
            hardness = block.func_176195_g(block.func_176223_P(), null, BlockPos.field_177992_a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SetEffect.registryNameContains(block, meta, new String[]{"bedrock", "obsidian", "brick", "heavy", "sturdy"}) && (hardness == -1.0 || hardness >= 2.0);
    }
}

