/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectPuller
extends SetEffect {
    protected SetEffectPuller() {
        this.color = TextFormatting.GRAY;
        this.description = "Pulls in nearby entities";
        this.usesButton = true;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && BlockArmor.key.isKeyDown(player) && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            AxisAlignedBB aabb = player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0);
            List list = player.field_70170_p.func_72839_b((Entity)player, aabb);
            if (!list.isEmpty()) {
                for (Entity entityCollided : list) {
                    if (entityCollided.func_180427_aV()) continue;
                    double xVel = entityCollided.field_70165_t - player.field_70165_t;
                    double yVel = entityCollided.field_70163_u - player.field_70163_u;
                    double zVel = entityCollided.field_70161_v - player.field_70161_v;
                    double velScale = 4.0 / Math.sqrt(xVel * xVel + yVel * yVel + zVel * zVel);
                    entityCollided.func_70024_g(-velScale * xVel, -velScale * yVel, -velScale * zVel);
                    entityCollided.field_70133_I = true;
                }
                world.func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEvents.field_187712_dQ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() + 0.5f);
                this.setCooldown(player, 40);
                this.damageArmor((EntityLivingBase)player, 1, false);
            } else {
                this.setCooldown(player, 5);
            }
        }
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        return SetEffect.registryNameContains(block, meta, new String[]{"pull", "attract", "magnet"}) || SetEffect.registryNameContains(block, meta, new String[]{"piston"}) && SetEffect.registryNameContains(block, meta, new String[]{"sticky"});
    }
}

