/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.common.seteffect;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class SetEffectSlimey
extends SetEffect {
    private static EntityLivingBase bouncingEntity;
    private static double motionY;

    protected SetEffectSlimey() {
        this.color = TextFormatting.GREEN;
        this.description = "Bounces off walls and floors";
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (ArmorSet.getFirstSetItem((EntityLivingBase)player, this) == stack && world.field_72995_K && !player.func_70093_af()) {
            if (!player.field_70122_E && !player.func_184613_cA()) {
                player.field_70159_w *= 1.07;
                player.field_70179_y *= 1.07;
            }
            if (!player.func_184811_cZ().func_185141_a(stack.func_77973_b()) && player.field_70123_F && Math.sqrt(Math.pow(player.field_70165_t - player.field_71091_bM, 2.0) + Math.pow(player.field_70161_v - player.field_71097_bO, 2.0)) >= 1.1) {
                this.setCooldown(player, 10);
                double multiplier = 0.1;
                if (player.field_70159_w == 0.0) {
                    player.field_70159_w = -(player.field_70165_t - player.field_71091_bM) * multiplier;
                    player.field_70179_y = (player.field_70161_v - player.field_71097_bO) * multiplier;
                } else if (player.field_70179_y == 0.0) {
                    player.field_70159_w = (player.field_70165_t - player.field_71091_bM) * multiplier;
                    player.field_70179_y = -(player.field_70161_v - player.field_71097_bO) * multiplier;
                }
                player.field_70181_x += 0.1;
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187876_fn, SoundCategory.BLOCKS, 0.4f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEvent(LivingFallEvent event) {
        if (ArmorSet.getWornSetEffects(event.getEntityLiving()).contains(this)) {
            if (!(event.getEntity() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.func_70093_af()) {
                event.setDamageMultiplier(0.0f);
                if (player.field_70170_p.field_72995_K) {
                    if (event.getDistance() <= 40.0f && (double)event.getDistance() > 2.0) {
                        player.field_70181_x = Math.abs(player.field_70181_x * 0.9);
                    } else if (event.getDistance() > 40.0f && event.getDistance() <= 100.0f) {
                        player.field_70181_x = Math.abs(player.field_70181_x * 0.9 * 1.5);
                    } else if (event.getDistance() > 100.0f) {
                        player.field_70181_x = Math.abs(player.field_70181_x * 0.9 * 2.0);
                    }
                    if ((double)event.getDistance() > 2.0) {
                        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, event.getDistance() > 40.0f ? SoundEvents.field_187882_fq : SoundEvents.field_187886_fs, SoundCategory.PLAYERS, 0.4f, 1.0f);
                    }
                    player.field_70160_al = true;
                    player.field_70122_E = false;
                    bouncingEntity = player;
                    motionY = player.field_70181_x;
                } else {
                    event.setCanceled(true);
                }
            } else {
                event.setDamageMultiplier(0.1f);
            }
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.PlayerTickEvent event) {
        if (bouncingEntity != null && event.player == bouncingEntity && SetEffectSlimey.bouncingEntity.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            SetEffectSlimey.bouncingEntity.field_70181_x = motionY;
            SetEffectSlimey.bouncingEntity.field_70143_R = 0.0f;
            bouncingEntity = null;
        }
    }

    @Override
    protected boolean isValid(Block block, int meta) {
        return SetEffect.registryNameContains(block, meta, new String[]{"slime"});
    }
}

