/*
 * Decompiled with CFR 0.152.
 */
package twopiradians.blockArmor.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import twopiradians.blockArmor.common.BlockArmor;
import twopiradians.blockArmor.common.config.Config;
import twopiradians.blockArmor.common.item.ArmorSet;
import twopiradians.blockArmor.common.seteffect.SetEffect;

public class PacketSyncConfig
implements IMessage {
    public void fromBytes(ByteBuf buf) {
        Config.piecesForSet = buf.readInt();
        Property prop = Config.getPiecesForSetProp();
        prop.set(Config.piecesForSet);
        Config.effectsUseDurability = buf.readBoolean();
        prop = Config.getEffectsUseDurablityProp();
        prop.set(Config.effectsUseDurability);
        Config.registerDisabledItems = buf.readBoolean();
        prop = Config.getRegisterDisableItemsProp();
        prop.set(Config.registerDisabledItems);
        Config.disabledSetEffects.clear();
        int numEffects = buf.readInt();
        for (SetEffect effect : SetEffect.SET_EFFECTS) {
            prop = Config.getSetEffectProp(effect.toString());
            prop.set(true);
        }
        for (int i = 0; i < numEffects; ++i) {
            try {
                String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Class<?> clazz = Class.forName(string);
                if (clazz == null) continue;
                Config.disabledSetEffects.add(clazz);
                for (SetEffect effect : SetEffect.SET_EFFECTS) {
                    if (effect.getClass() != clazz) continue;
                    prop = Config.getSetEffectProp(effect.toString());
                    prop.set(false);
                }
                continue;
            }
            catch (Exception e) {
                BlockArmor.logger.debug("Caught exception while reading disabledSetEffects from PacketSyncConfig: ", (Throwable)e);
            }
        }
        int numSets = buf.readInt();
        ArrayList<ArmorSet> enabledSets = new ArrayList<ArmorSet>();
        for (int i = 0; i < numSets; ++i) {
            try {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                ArmorSet set = ArmorSet.nameToSetMap.get(name);
                if (set == null) continue;
                enabledSets.add(set);
                continue;
            }
            catch (Exception e) {
                BlockArmor.logger.debug("Caught exception while reading enabled sets from PacketSyncConfig: ", (Throwable)e);
            }
        }
        for (ArmorSet set : ArmorSet.allSets) {
            ModContainer mod;
            boolean enabled = enabledSets.contains(set);
            if (enabled != set.isEnabled()) {
                if (enabled) {
                    set.enable();
                } else {
                    set.disable();
                }
            }
            if ((mod = (ModContainer)Loader.instance().getIndexedModList().get(set.modid)) == null) continue;
            prop = Config.getArmorSetProp(mod.getName(), set);
            prop.set(enabled);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(Config.piecesForSet);
        buf.writeBoolean(Config.effectsUseDurability);
        buf.writeBoolean(Config.registerDisabledItems);
        buf.writeInt(Config.disabledSetEffects.size());
        for (Class clazz : Config.disabledSetEffects) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)clazz.getName());
        }
        ArrayList<String> enabledNames = new ArrayList<String>();
        for (ArmorSet set : ArmorSet.allSets) {
            if (!set.isEnabled()) continue;
            enabledNames.add(ArmorSet.getItemStackRegistryName(set.stack));
        }
        buf.writeInt(enabledNames.size());
        for (String name : enabledNames) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncConfig, IMessage> {
        public IMessage onMessage(PacketSyncConfig packet, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Config.config.save();
                    BlockArmor.logger.info("Synced client config with server config.");
                    Config.syncJEIIngredients();
                }
            });
            return null;
        }
    }
}

